function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = World_Economy_Cartel_Fracking_VD.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(80, 148);
g1(1,28)=T(37)+T(41);
g1(1,31)=T(37);
g1(1,11)=T(39);
g1(1,45)=exp(y(28))*T(32)*T(87);
g1(1,46)=T(123);
g1(1,49)=T(124);
g1(1,56)=T(40);
g1(1,69)=exp(y(28));
g1(1,22)=T(38)*(-(T(24)*exp(y(28))*exp(y(11))));
g1(1,24)=T(38)*(-(exp(y(28))*T(24)));
g1(1,25)=T(262);
g1(1,83)=(-exp(y(28)));
g1(1,97)=(-1);
g1(1,138)=params(25);
g1(2,29)=T(26)*(-exp(y(29)))+y(103)*(-T(126))+exp(y(29))*y(73)+y(89)*(-(T(31)*params(4)*params(4)*exp(y(29)*params(4))))+params(25)*y(144)*T(126);
g1(2,30)=T(128);
g1(2,45)=(-exp(y(29)))*T(87);
g1(2,46)=(-exp(y(29)))*T(100);
g1(2,52)=T(130);
g1(2,73)=exp(y(29));
g1(2,89)=(-(T(31)*params(4)*exp(y(29)*params(4))));
g1(2,99)=(-1);
g1(2,140)=params(25);
g1(2,103)=(-T(42));
g1(2,144)=params(25)*T(42);
g1(3,29)=T(128);
g1(3,30)=y(103)*(-T(131))+y(87)*(-(T(29)*params(4)*params(4)*exp(y(30)*params(4))))+exp(y(30))*y(73)+y(78)*y(41)*T(29)*params(4)*(params(4)-1)*(params(4)-1)*exp(y(30)*(params(4)-1))+params(25)*y(144)*T(131);
g1(3,41)=y(78)*T(29)*params(4)*(params(4)-1)*exp(y(30)*(params(4)-1));
g1(3,52)=T(133);
g1(3,73)=exp(y(30));
g1(3,78)=y(41)*T(29)*params(4)*(params(4)-1)*exp(y(30)*(params(4)-1));
g1(3,87)=(-(T(29)*params(4)*exp(y(30)*params(4))));
g1(3,98)=(-1);
g1(3,139)=params(25);
g1(3,103)=(-T(43));
g1(3,144)=params(25)*T(43);
g1(4,28)=T(37);
g1(4,31)=T(26)*T(44)+y(104)*(-T(134))+y(93)*(-T(32))+T(32)*y(92)+params(25)*y(145)*T(134);
g1(4,32)=T(136);
g1(4,45)=T(44)*T(87);
g1(4,46)=T(44)*T(100);
g1(4,51)=T(111);
g1(4,53)=T(138);
g1(4,65)=T(26)*T(122);
g1(4,92)=T(32);
g1(4,93)=(-T(32));
g1(4,101)=(-1);
g1(4,142)=params(25);
g1(4,104)=(-T(45));
g1(4,145)=params(25)*T(45);
g1(5,31)=T(136);
g1(5,32)=y(104)*(-T(139))+y(93)*(-exp(y(32)))+exp(y(32))*y(90)+params(25)*y(145)*T(139);
g1(5,53)=T(141);
g1(5,90)=exp(y(32));
g1(5,93)=(-exp(y(32)));
g1(5,100)=(-1);
g1(5,141)=params(25);
g1(5,104)=(-T(46));
g1(5,145)=params(25)*T(46);
g1(6,33)=T(48);
g1(6,37)=T(54);
g1(6,117)=T(252);
g1(6,125)=params(25)*exp(y(33))*params(6)*exp(params(5)*y(37));
g1(6,86)=exp(y(33));
g1(6,129)=params(25)*(-(exp(y(33))*(1-exp((-y(117)))*exp(y(37)))));
g1(6,135)=T(265);
g1(7,34)=T(50);
g1(7,38)=T(143);
g1(7,125)=params(25)*params(6)*exp(params(5)*y(38))*exp(y(34));
g1(7,84)=exp(y(34));
g1(7,127)=params(25)*(-((1-exp(y(38)))*exp(y(34))));
g1(7,133)=params(25)*(-(exp(y(38))*exp(y(34))));
g1(8,35)=T(51);
g1(8,86)=(-(params(7)*exp(y(35))));
g1(8,89)=exp(y(35));
g1(8,132)=params(25)*(-((1-params(7))*exp(y(35))));
g1(9,36)=T(52);
g1(9,84)=(-(params(7)*exp(y(36))));
g1(9,87)=exp(y(36));
g1(9,130)=params(25)*(-((1-params(7))*exp(y(36))));
g1(10,33)=T(54);
g1(10,37)=params(25)*y(137)*(-exp(y(37)))+T(145);
g1(10,117)=T(252);
g1(10,125)=params(25)*exp(y(33))*params(6)*params(5)*exp(params(5)*y(37));
g1(10,129)=T(264);
g1(10,135)=T(265);
g1(10,137)=params(25)*(-exp(y(37)));
g1(11,107)=y(76)*T(125);
g1(11,34)=T(143);
g1(11,38)=T(49)+T(57)+y(79)*T(23)*params(6)*params(5)*(params(5)-1)*(params(5)-1)*exp(y(38)*(params(5)-1))+T(148)+params(25)*y(125)*exp(y(34))*params(6)*params(5)*params(5)*exp(params(5)*y(38));
g1(11,108)=y(76)*(-(T(23)*(-exp(y(38)))));
g1(11,115)=y(79)*T(55)+y(76)*T(56);
g1(11,125)=params(25)*exp(y(34))*params(6)*params(5)*exp(params(5)*y(38));
g1(11,76)=T(56);
g1(11,79)=T(55);
g1(11,127)=params(25)*(-(exp(y(34))*(-exp(y(38)))));
g1(11,133)=params(25)*(-(exp(y(38))*exp(y(34))));
g1(12,39)=exp(y(39))*y(72);
g1(12,72)=exp(y(39));
g1(13,11)=T(38)*y(22)*(-(T(24)*(-exp(y(11)))));
g1(13,49)=T(38)*y(22)*(-(T(24)*(1-exp(y(11)))))+T(38)*T(24)*y(24);
g1(13,22)=T(38)*(-(T(24)*(1-exp(y(11)))));
g1(13,76)=1;
g1(13,77)=(-params(7));
g1(13,24)=T(24)*T(38);
g1(14,30)=y(78)*T(29)*params(4)*(params(4)-1)*exp(y(30)*(params(4)-1));
g1(14,49)=T(38)*y(23)*(-(T(24)*(1-params(7))));
g1(14,23)=T(38)*(-(T(24)*(1-params(7))));
g1(14,77)=1;
g1(14,78)=params(4)*exp(y(30)*(params(4)-1))*T(29);
g1(15,42)=T(8)*y(93)+y(69)*(-(params(11)*T(12)*T(151)))+y(68)*(-(T(60)*T(155)+params(11)*T(59)*params(11)*T(59)*T(156)));
g1(15,43)=y(69)*(-(T(58)*params(11)*T(61)));
g1(15,13)=y(68)*(-(params(11)*T(59)*T(156)*T(171)));
g1(15,45)=y(68)*(-(params(11)*T(59)*T(97)*T(156)));
g1(15,50)=y(68)*(-(params(11)*T(59)*T(107)*T(156)));
g1(15,68)=(-(params(11)*T(59)*T(60)));
g1(15,69)=(-(params(11)*T(12)*T(58)));
g1(15,93)=T(8);
g1(16,42)=y(69)*(-(T(58)*params(11)*T(61)));
g1(16,43)=y(73)*(-exp(y(43)))+y(71)*(-(T(5)*T(19)*T(16)*exp(T(1)*y(50))*(1-params(11))*params(3)*T(161)))+y(70)*(-(T(17)*T(3)*T(16)*exp(T(1)*y(50))*(1-params(11))*(1-params(3))*T(161)))+exp(y(43))*y(68)+y(69)*(-(T(14)*params(11)*T(161)));
g1(16,13)=y(71)*T(173)+y(70)*(-(T(17)*T(174)));
g1(16,45)=T(162);
g1(16,50)=T(165);
g1(16,68)=exp(y(43));
g1(16,69)=(-(T(14)*params(11)*T(61)));
g1(16,70)=(-(T(17)*T(3)*T(16)*T(63)));
g1(16,71)=(-(T(5)*T(19)*T(16)*T(62)));
g1(16,73)=(-exp(y(43)));
g1(16,102)=(-1);
g1(16,143)=params(25);
g1(17,110)=params(25)*y(121)*(-(T(70)*params(11)*T(157)*T(158)));
g1(17,111)=params(25)*y(122)*(-(T(74)*(T(66)*T(77)*T(167)+T(67)*T(79)*T(167))))+params(25)*y(123)*T(168);
g1(17,44)=T(20)*y(73)+params(25)*y(125)*(-(T(20)*(1-params(10))))+params(25)*y(121)*(-(T(73)*T(187)+T(70)*T(70)*T(158)))+params(25)*y(122)*(-(T(74)*(T(76)*T(77)*T(185)+T(66)*T(76)*T(79)+T(66)*T(76)*T(79)+T(67)*T(76)*T(189))))+params(25)*y(123)*(-(T(65)*(T(79)*T(81)*T(82)+T(80)*T(81)*T(189)+T(79)*T(81)*T(82)+T(77)*T(81)*T(192))))+params(25)*y(124)*(-(exp((1-params(3))*y(112))*exp(T(1)*y(116))*params(3)*params(3)*exp(params(3)*y(44))));
g1(17,112)=params(25)*y(121)*(-(T(73)*T(225)+T(70)*T(158)*T(64)*T(69)*T(67)*T(224)))+params(25)*y(122)*(-((T(66)*T(76)*T(77)+T(67)*T(76)*T(79))*T(226)+T(74)*(T(66)*T(76)*T(78)*T(67)*T(224)+T(67)*T(76)*T(227))))+params(25)*y(123)*(-((T(80)*T(79)*T(81)+T(77)*T(81)*T(82))*T(224)+T(65)*(T(80)*T(81)*T(227)+T(82)*T(81)*T(78)*T(67)*T(224))))+params(25)*y(124)*(-(exp(T(1)*y(116))*params(3)*exp(params(3)*y(44))*(1-params(3))*exp((1-params(3))*y(112))));
g1(17,116)=params(25)*y(121)*(-(T(73)*T(244)+T(70)*T(158)*T(71)*(1-params(11))*T(1)*exp(T(1)*y(116))))+params(25)*y(122)*(-(T(74)*T(246)))+params(25)*y(123)*(-(T(65)*T(247)))+params(25)*y(124)*(-(exp((1-params(3))*y(112))*params(3)*exp(params(3)*y(44))*T(1)*exp(T(1)*y(116))));
g1(17,121)=params(25)*(-(T(70)*T(73)));
g1(17,122)=params(25)*(-(T(74)*(T(66)*T(76)*T(77)+T(67)*T(76)*T(79))));
g1(17,123)=params(25)*T(83);
g1(17,124)=params(25)*(-(exp((1-params(3))*y(112))*exp(T(1)*y(116))*params(3)*exp(params(3)*y(44))));
g1(17,73)=T(20);
g1(17,125)=params(25)*(-(T(20)*(1-params(10))));
g1(18,28)=exp(y(28))*T(32)*T(87);
g1(18,29)=(-exp(y(29)))*T(87);
g1(18,31)=T(44)*T(87);
g1(18,42)=y(68)*(-(T(97)*params(11)*T(59)*T(156)));
g1(18,43)=T(162);
g1(18,13)=y(72)*(-(T(88)*exp(T(1)*y(50))*params(3)*exp(y(13)*params(3))))+y(71)*(-(T(90)*(T(19)*T(18)*T(91)*T(170)+T(16)*T(18)*T(172))+T(5)*(T(18)*T(92)*T(172)+T(19)*T(18)*T(176))))+y(70)*(-(T(17)*(T(15)*T(92)*T(169)+T(3)*T(15)*T(176))+T(94)*T(177)))+y(68)*(-(T(97)*T(156)*T(171)+T(60)*T(179)));
g1(18,14)=y(75)*T(197);
g1(18,45)=(T(44)-exp(y(29)))*T(204)+y(75)*(-(params(1)*T(204)/T(28)))+T(4)*y(74)+y(72)*(-(exp(T(1)*y(50))*exp(y(13)*params(3))*(1-params(3))*T(88)))+y(71)*T(209)+y(70)*T(213)+y(68)*(-(T(97)*T(97)*T(156)+T(60)*T(214)))+params(25)*y(126)*T(216);
g1(18,112)=params(25)*y(126)*(-((-(T(87)*T(231)))/(T(26)*T(26))));
g1(18,15)=y(75)*T(232);
g1(18,46)=(T(44)-exp(y(29)))*T(234)+y(75)*(-(params(1)*T(234)/T(28)))+params(25)*y(126)*T(236);
g1(18,113)=params(25)*y(126)*(-((-(T(87)*params(1)*exp(y(113))*T(230)))/(T(26)*T(26))));
g1(18,50)=y(72)*(-(T(88)*exp(y(13)*params(3))*T(1)*exp(T(1)*y(50))))+T(220)+T(221)+y(68)*(-(T(60)*T(222)+T(97)*T(107)*T(156)));
g1(18,51)=T(223);
g1(18,65)=T(87)*T(122);
g1(18,68)=(-(T(60)*T(97)));
g1(18,70)=T(95);
g1(18,71)=T(93);
g1(18,72)=T(89);
g1(18,74)=T(4);
g1(18,75)=(-(params(1)*T(87)/T(28)));
g1(18,126)=params(25)*(-((-(T(87)*T(99)))/(T(26)*T(26))));
g1(19,28)=T(123);
g1(19,29)=(-exp(y(29)))*T(100);
g1(19,31)=T(44)*T(100);
g1(19,14)=y(75)*T(198);
g1(19,45)=(T(44)-exp(y(29)))*T(217)+y(75)*(-(params(1)*T(217)/T(28)))+params(25)*y(126)*(-(T(218)/T(215)));
g1(19,112)=params(25)*y(126)*(-((-(T(100)*T(231)))/(T(26)*T(26))));
g1(19,15)=y(75)*T(233);
g1(19,46)=(T(44)-exp(y(29)))*T(237)+y(75)*(-(params(1)*T(237)/T(28)))+exp(y(46))*y(73)+params(25)*y(126)*(-((T(26)*T(26)*(-(T(99)*T(237)))-(-(T(99)*T(100)))*T(235))/T(215)));
g1(19,113)=params(25)*y(126)*(-((-(T(100)*params(1)*exp(y(113))*T(230)))/(T(26)*T(26))));
g1(19,51)=T(100)*T(110);
g1(19,65)=T(100)*T(122);
g1(19,73)=exp(y(46));
g1(19,75)=T(101);
g1(19,126)=params(25)*(-((-(T(99)*T(100)))/(T(26)*T(26))));
g1(20,47)=exp(y(47))*y(71)+T(38)*y(21)*(-(exp(y(47))*T(24)));
g1(20,49)=T(38)*y(21)*(-(exp(y(47))*T(24)));
g1(20,71)=exp(y(47));
g1(20,21)=T(38)*(-(exp(y(47))*T(24)));
g1(21,48)=exp(y(48))*y(70)+y(74)*(-(T(21)*T(240)));
g1(21,70)=exp(y(48));
g1(21,74)=(-(T(21)*T(102)));
g1(22,28)=T(124);
g1(22,11)=T(146);
g1(22,40)=T(38)*y(22)*(-(T(24)*(1-exp(y(11)))))+T(38)*T(24)*y(24);
g1(22,41)=T(38)*y(23)*(-(T(24)*(1-params(7))));
g1(22,47)=T(38)*y(21)*(-(exp(y(47))*T(24)));
g1(22,49)=T(103);
g1(22,56)=T(121);
g1(22,57)=T(38)*y(25)*(-(T(24)*(1-exp(y(56)))));
g1(22,58)=T(38)*y(26)*(-(T(24)*(1-params(23))));
g1(22,21)=T(38)*(-(T(24)*(1+exp(y(47))-params(10))));
g1(22,75)=T(24);
g1(22,22)=T(38)*(-(T(24)*(exp(y(28))*exp(y(11))+y(40)*(1-exp(y(11)))-params(6)*exp(params(5)*y(11)))));
g1(22,23)=T(38)*(-(y(41)*T(24)*(1-params(7))));
g1(22,24)=T(38)*(T(24)*params(6)*params(5)*exp(y(11)*(params(5)-1))-T(24)*(exp(y(28))-y(40)));
g1(22,25)=T(38)*(-(T(24)*(exp(y(28))*exp(y(56))+y(57)*(1-exp(y(56)))-params(22)*exp(params(21)*y(56)))));
g1(22,26)=T(38)*(-(y(58)*T(24)*(1-params(23))));
g1(23,42)=y(68)*(-(T(107)*params(11)*T(59)*T(156)));
g1(23,43)=T(165);
g1(23,13)=y(72)*T(180)+y(71)*(-(T(5)*T(181)))+y(70)*(-(T(17)*T(182)))+y(68)*(-(T(107)*T(156)*T(171)+T(60)*T(106)*T(96)*T(170)));
g1(23,45)=y(72)*(-(T(88)*exp(y(13)*params(3))*T(1)*exp(T(1)*y(50))))+T(220)+T(221)+y(68)*(-(T(107)*T(97)*T(156)+T(60)*T(222)));
g1(23,50)=y(72)*T(241)+y(71)*(-(T(5)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(50))))+y(70)*T(242)+y(68)*(-(T(107)*T(107)*T(156)+T(60)*T(243)));
g1(23,68)=(-(T(60)*T(107)));
g1(23,70)=(-(T(17)*T(3)*T(16)*T(105)));
g1(23,71)=(-(T(5)*T(19)*T(16)*T(104)));
g1(23,72)=(-(exp(y(45)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(50))));
g1(23,95)=1;
g1(23,136)=params(25)*(-params(15));
g1(23,146)=T(108)*(-params(16));
g1(24,31)=T(111);
g1(24,6)=T(114);
g1(24,10)=T(114);
g1(24,45)=T(223);
g1(24,46)=T(100)*T(110);
g1(24,51)=T(26)*T(249)+T(250);
g1(24,65)=T(26)*T(260);
g1(24,86)=T(113);
g1(24,92)=T(112);
g1(24,94)=1;
g1(25,29)=T(130);
g1(25,30)=T(133);
g1(25,52)=y(103)*(-T(253))+y(88)*(-(T(30)*params(4)*params(4)*exp(y(52)*params(4))))+exp(y(52))*y(73)+y(82)*y(58)*T(30)*params(4)*(params(4)-1)*(params(4)-1)*exp(y(52)*(params(4)-1))+params(25)*y(144)*T(253);
g1(25,58)=y(82)*T(30)*params(4)*(params(4)-1)*exp(y(52)*(params(4)-1));
g1(25,73)=exp(y(52));
g1(25,82)=y(58)*T(30)*params(4)*(params(4)-1)*exp(y(52)*(params(4)-1));
g1(25,88)=(-(T(30)*params(4)*exp(y(52)*params(4))));
g1(25,103)=(-T(115));
g1(25,144)=params(25)*T(115);
g1(26,31)=T(138);
g1(26,32)=T(141);
g1(26,53)=y(104)*(-T(254))+y(93)*(-exp(y(53)))+exp(y(53))*y(91)+params(25)*y(145)*T(254);
g1(26,91)=exp(y(53));
g1(26,93)=(-exp(y(53)));
g1(26,104)=(-T(116));
g1(26,145)=params(25)*T(116);
g1(27,54)=T(117);
g1(27,118)=T(258);
g1(27,125)=params(25)*params(22)*exp(params(21)*y(118))*exp(y(54));
g1(27,85)=exp(y(54));
g1(27,128)=params(25)*(-((1-exp(y(118)))*exp(y(54))));
g1(27,134)=params(25)*(-(exp(y(118))*exp(y(54))));
g1(28,55)=T(118);
g1(28,85)=(-(params(23)*exp(y(55))));
g1(28,88)=exp(y(55));
g1(28,131)=params(25)*(-((1-params(23))*exp(y(55))));
g1(29,28)=T(40);
g1(29,49)=T(121);
g1(29,19)=T(255);
g1(29,56)=y(91)*T(119)+y(85)*T(120)+y(83)*params(22)*params(21)*(params(21)-1)*(params(21)-1)*exp(y(56)*(params(21)-1))+y(73)*exp(y(19))*params(22)*params(21)*params(21)*exp(params(21)*y(56))+T(256);
g1(29,57)=T(257);
g1(29,73)=exp(y(19))*params(22)*params(21)*exp(params(21)*y(56));
g1(29,25)=T(263);
g1(29,83)=params(22)*params(21)*(params(21)-1)*exp(y(56)*(params(21)-1));
g1(29,85)=T(120);
g1(29,91)=T(119);
g1(30,49)=T(38)*y(25)*(-(T(24)*(1-exp(y(56)))));
g1(30,56)=T(257);
g1(30,25)=T(38)*(-(T(24)*(1-exp(y(56)))));
g1(30,80)=1;
g1(30,81)=(-params(23));
g1(30,83)=1;
g1(31,49)=T(38)*y(26)*(-(T(24)*(1-params(23))));
g1(31,52)=y(82)*T(30)*params(4)*(params(4)-1)*exp(y(52)*(params(4)-1));
g1(31,26)=T(38)*(-(T(24)*(1-params(23))));
g1(31,81)=1;
g1(31,82)=params(4)*exp(y(52)*(params(4)-1))*T(30);
g1(32,97)=1;
g1(33,98)=1;
g1(34,99)=1;
g1(35,100)=1;
g1(36,101)=1;
g1(37,102)=1;
g1(38,31)=T(26)*T(122);
g1(38,45)=T(87)*T(122);
g1(38,46)=T(100)*T(122);
g1(38,51)=T(26)*T(251);
g1(38,65)=exp(y(65))*y(96)+T(26)*T(261);
g1(38,96)=exp(y(65));
g1(39,103)=1;
g1(40,104)=1;
g1(41,42)=(-(params(11)*T(59)*T(60)));
g1(41,43)=exp(y(43));
g1(41,13)=(-(T(60)*T(171)));
g1(41,45)=(-(T(60)*T(97)));
g1(41,50)=(-(T(60)*T(107)));
g1(42,28)=exp(y(28));
g1(42,42)=(-(params(11)*T(12)*T(58)));
g1(42,43)=(-(T(14)*params(11)*T(61)));
g1(43,43)=(-(T(17)*T(3)*T(16)*T(63)));
g1(43,13)=(-(T(17)*T(177)));
g1(43,45)=T(95);
g1(43,48)=exp(y(48));
g1(43,50)=(-(T(17)*T(3)*T(16)*T(105)));
g1(44,43)=(-(T(5)*T(19)*T(16)*T(62)));
g1(44,13)=(-(T(5)*(T(19)*T(18)*T(91)*T(170)+T(16)*T(18)*T(172))));
g1(44,45)=T(93);
g1(44,47)=exp(y(47));
g1(44,50)=(-(T(5)*T(19)*T(16)*T(104)));
g1(45,39)=exp(y(39));
g1(45,13)=(-(exp(y(45)*(1-params(3)))*exp(T(1)*y(50))*params(3)*exp(y(13)*params(3))));
g1(45,45)=T(89);
g1(45,50)=(-(exp(y(45)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(50))));
g1(46,29)=exp(y(29));
g1(46,30)=exp(y(30));
g1(46,6)=params(6)*exp(params(5)*y(10))*exp(y(6));
g1(46,7)=params(6)*exp(params(5)*y(11))*exp(y(7));
g1(46,10)=exp(y(6))*params(6)*params(5)*exp(params(5)*y(10));
g1(46,11)=exp(y(7))*params(6)*params(5)*exp(params(5)*y(11));
g1(46,43)=(-exp(y(43)));
g1(46,13)=(-(exp(y(13))*(1-params(10))));
g1(46,44)=T(20);
g1(46,46)=exp(y(46));
g1(46,52)=exp(y(52));
g1(46,19)=params(22)*exp(params(21)*y(56))*exp(y(19));
g1(46,56)=exp(y(19))*params(22)*params(21)*exp(params(21)*y(56));
g1(47,45)=T(4);
g1(47,48)=(-(T(21)*T(102)));
g1(48,114)=(-(T(23)*exp(y(114))));
g1(48,115)=(-(T(23)*(1+exp(y(114))-params(10))));
g1(49,14)=(-((-(params(1)*T(26)*T(196)))/(T(28)*T(28))));
g1(49,45)=(-(params(1)*T(87)/T(28)));
g1(49,15)=(-((-(params(1)*T(26)*exp(y(15))*T(195)))/(T(28)*T(28))));
g1(49,46)=T(101);
g1(49,49)=T(24);
g1(50,107)=T(125);
g1(50,38)=T(56);
g1(50,40)=1;
g1(50,108)=(-(T(23)*(1-exp(y(38)))));
g1(50,115)=(-(T(23)*(exp(y(38))*exp(y(107))+(1-exp(y(38)))*y(108)-params(6)*exp(params(5)*y(38)))));
g1(51,40)=(-params(7));
g1(51,41)=1;
g1(51,109)=(-(T(23)*(1-params(7))));
g1(51,115)=(-(T(23)*(1-params(7))*y(109)));
g1(52,30)=y(41)*T(29)*params(4)*(params(4)-1)*exp(y(30)*(params(4)-1));
g1(52,41)=params(4)*exp(y(30)*(params(4)-1))*T(29);
g1(53,107)=(-(T(23)*exp(y(107))));
g1(53,38)=T(55);
g1(53,108)=T(23);
g1(53,115)=T(23)*params(6)*params(5)*exp(y(38)*(params(5)-1))-T(23)*(exp(y(107))-y(108));
g1(54,107)=(-(T(23)*exp(y(107))*exp(y(118))));
g1(54,115)=(-(T(23)*(exp(y(107))*exp(y(118))+(1-exp(y(118)))*y(119)-params(22)*exp(params(21)*y(118)))));
g1(54,118)=(-(T(23)*(exp(y(107))*exp(y(118))+y(119)*(-exp(y(118)))-params(22)*params(21)*exp(params(21)*y(118)))));
g1(54,57)=1;
g1(54,119)=(-(T(23)*(1-exp(y(118)))));
g1(55,115)=(-(T(23)*(1-params(23))*y(120)));
g1(55,57)=(-params(23));
g1(55,58)=1;
g1(55,120)=(-(T(23)*(1-params(23))));
g1(56,52)=y(58)*T(30)*params(4)*(params(4)-1)*exp(y(52)*(params(4)-1));
g1(56,58)=params(4)*exp(y(52)*(params(4)-1))*T(30);
g1(57,28)=(-exp(y(28)));
g1(57,56)=params(22)*params(21)*(params(21)-1)*exp(y(56)*(params(21)-1));
g1(57,57)=1;
g1(58,7)=(-(exp(y(7))*(1-exp(y(11)))));
g1(58,34)=exp(y(34));
g1(58,36)=(-(params(7)*exp(y(36))));
g1(58,11)=(-(exp(y(7))*(-exp(y(11)))));
g1(59,19)=(-(exp(y(19))*(1-exp(y(56)))));
g1(59,54)=exp(y(54));
g1(59,55)=(-(params(23)*exp(y(55))));
g1(59,56)=T(120);
g1(60,6)=(-(exp(y(6))*(1-exp((-y(51)))*exp(y(10)))));
g1(60,33)=exp(y(33));
g1(60,35)=(-(params(7)*exp(y(35))));
g1(60,10)=T(144);
g1(60,51)=T(113);
g1(61,30)=(-(T(29)*params(4)*exp(y(30)*params(4))));
g1(61,9)=(-((1-params(7))*exp(y(9))));
g1(61,36)=exp(y(36));
g1(62,52)=(-(T(30)*params(4)*exp(y(52)*params(4))));
g1(62,20)=(-((1-params(23))*exp(y(20))));
g1(62,55)=exp(y(55));
g1(63,29)=(-(T(31)*params(4)*exp(y(29)*params(4))));
g1(63,8)=(-((1-params(7))*exp(y(8))));
g1(63,35)=exp(y(35));
g1(64,32)=exp(y(32));
g1(64,7)=(-(exp(y(7))*exp(y(11))));
g1(64,11)=(-(exp(y(7))*exp(y(11))));
g1(65,53)=exp(y(53));
g1(65,19)=T(119);
g1(65,56)=T(119);
g1(66,31)=T(32);
g1(66,6)=T(142);
g1(66,10)=T(142);
g1(66,51)=T(112);
g1(67,31)=(-T(32));
g1(67,32)=(-exp(y(32)));
g1(67,42)=T(8);
g1(67,53)=(-exp(y(53)));
g1(68,51)=1;
g1(68,147)=(-1);
g1(69,16)=(-params(15));
g1(69,50)=1;
g1(69,148)=(-1);
g1(69,27)=(-params(16));
g1(70,10)=(-exp(y(10)));
g1(70,65)=exp(y(65));
g1(71,1)=1;
g1(71,28)=(-1);
g1(71,59)=1;
g1(72,3)=1;
g1(72,30)=(-1);
g1(72,60)=1;
g1(73,2)=1;
g1(73,29)=(-1);
g1(73,61)=1;
g1(74,5)=1;
g1(74,32)=(-1);
g1(74,62)=1;
g1(75,4)=1;
g1(75,31)=(-1);
g1(75,63)=1;
g1(76,12)=1;
g1(76,43)=(-1);
g1(76,64)=1;
g1(77,2)=exp(y(2))/T(35);
g1(77,29)=(-T(42));
g1(77,3)=exp(y(3))/T(35);
g1(77,30)=(-T(43));
g1(77,17)=exp(y(17))/T(35);
g1(77,52)=(-T(115));
g1(77,66)=1;
g1(78,4)=exp(y(4))/T(36);
g1(78,31)=(-T(45));
g1(78,5)=exp(y(5))/T(36);
g1(78,32)=(-T(46));
g1(78,18)=exp(y(18))/T(36);
g1(78,53)=(-T(116));
g1(78,67)=1;
g1(79,136)=(-1);
g1(79,105)=1;
g1(80,16)=(-1);
g1(80,106)=1;

end
